# Début programme générateur de fréquence a la demande (Graphique)

# PWM est l'acronyme anglais de : Pulse Width Modulation
# Sortie PWM peut etre traduit en "Signal de périodique a largeur d'impulsion variable"
# -> Les paramètres de temps du singal sont programmable.
# -> L'amplitude du signal est fixe a 0 ou 5v (non programmable)

from time import sleep

# Nous importons le seul élément Arduino de pyfirmata2Ext
from pyfirmata2Ext import Arduino

# Nous importons la fonction de calcul des paramètre PWM du fichier libCalculsPWM.py
# Le fichier libCalculsPWM.py doit etre présent dans le meme répertoire que ce programme python.
from libCalculsPWM import determinerParametres

# Importation de la librairie graphique (native a Pyhton)
from tkinter import *

# Instanciation d'un objet représentant la carte Plug'Uno.
# Arduino.AUTODETECT peut être remplacé par l'identifiant de port-série (ex : "COM1").
# Arduino.AUTODETECT peut ne pas fonctionner correctement avec les port-serie Bluetooth.
plugUno = Arduino(Arduino.AUTODETECT)

# Class de creation d'une fenetre graphique.
# Utilise Tkinter. Referez-vous a la documentation en ligne :
# https://docs.python.org/2/library/tkinter.html
#
# Par conveignance, les champs text de l'interface graphique sont en 1 section ci-dessous
TitreDeLaFenetre = "Générateur de Fréquence PWM sur D3"
Phrase1_HautDeFenetre = "Déplacer un des curseurs pour obtenir un signal PWM sur D3."
Phrase2_HautDeFenetre = "Seul la fréquence correspondante au dernier cuseur manipulé est effective.\n"
LegendeCurseurFrequence1 = "31~1000 Hz"
LegendeCurseurFrequence2 = "31~20 0000 Hz"
LegendeCurseurFrequence3 = "31~4 000 000 Hz"
SectionParametreLigne1 = "\nConfigutation active (fréquence cible : "
SectionParametreLigne2 = "Prescaler/Diviseur = "
SectionParametreLigne3 = "Période (impulsion) = "
SectionParametreLigne4 = "Rapport cyclique (impulsion) = "
SectionParametreLigne5 = "Fréquence effective (Hz) : "
SectionParametreLigne6 = "Rapport cyclique effectif = "
class Interface(Frame):
    def __init__(self, root, **kwargs):
        Frame.__init__(self, root,**kwargs)
        root.title(TitreDeLaFenetre)
        root.geometry("600x400")
        root.resizable(0,0)
        windowWidth = root.winfo_reqwidth()
        windowHeight = root.winfo_reqheight()
        positionRight = int(root.winfo_screenwidth()/2 - windowWidth/2)
        positionDown = int(root.winfo_screenheight()/2 - windowHeight/2)
        root.geometry("+{}+{}".format(positionRight, positionDown))

        Label(root,text=Phrase1_HautDeFenetre).pack()
        Label(root,text=Phrase2_HautDeFenetre).pack()

        Label(root,text=LegendeCurseurFrequence1).pack()
        Scale(root, from_=31, to=1000,resolution = 1, orient=HORIZONTAL,length=550,command=self.appliquerPWMconfiguration).pack()
        
        Label(root,text=LegendeCurseurFrequence2).pack()
        Scale(root, from_=31, to=20000,resolution = 1, orient=HORIZONTAL,length=550,command=self.appliquerPWMconfiguration).pack()

        Label(root,text=LegendeCurseurFrequence3).pack()
        Scale(root, from_=31, to=4000000,resolution = 1, orient=HORIZONTAL,length=550,command=self.appliquerPWMconfiguration).pack()

        self.paramL1 = Label(root,text=SectionParametreLigne1+"n\\a)");self.paramL1.pack()
        self.paramL2 = Label(root,text=SectionParametreLigne2+"n\\a");self.paramL2.pack()
        self.paramL3 = Label(root,text=SectionParametreLigne3+"n\\a");self.paramL3.pack()
        self.paramL4 = Label(root,text=SectionParametreLigne4+"n\\a");self.paramL4.pack()
        self.paramL5 = Label(root,text=SectionParametreLigne5+"n\\a");self.paramL5.pack()
        self.paramL6 = Label(root,text=SectionParametreLigne6+"n\\a");self.paramL6.pack()
        
        
    # Cette méthode est appelé quand un des Slider (appelé 'Scale' par Tkinter) est manipulé
    def appliquerPWMconfiguration(self,val):
        # Recupere une configuration pour PWM-D3 selon la fréquence souhaité
        cfg = determinerParametres(int(val))
        # Envoie la configuration de PWM-D3 a Plug'Uno
        # Le fonctionnement et signigications des paramètres est détaillé dans ../PWM_D3_Détaillé.py
        plugUno.setPWMConfigD3( cfg[0], cfg[1], cfg[2] )
        # Mise a jour des informations de configurations (bas de la fenetre)
        self.paramL1.config(text=SectionParametreLigne1+str(val)+' Hz)')
        self.paramL2.config(text=SectionParametreLigne2+str(cfg[0]))
        self.paramL3.config(text=SectionParametreLigne3+str(cfg[1]))
        self.paramL4.config(text=SectionParametreLigne4+str(cfg[2]))
        self.paramL5.config(text=SectionParametreLigne5+"{:.3f}".format(cfg[3]))
        self.paramL6.config(text=SectionParametreLigne6+"{:.3f}".format(cfg[4]))

        # Facultatif, dans le cas d'un haut-parleur raccordé a PWM D3, le ralentissetement de...
        #...l'application adoucie les transitions ( entre deux changement de fréquence ).
        sleep(0.015)
        
interface = Interface(Tk())
interface.mainloop()

# Arrete le signal le signal PWM avant de quiter
plugUno.setPWMConfigD3(1,0,0)

# Fermer la connection a Plug'Uno
plugUno.exit()

# Met fin a l'exécution du programme Python.
#exit()

# Fin programme générateur de fréquence a la demande (Graphique)
